unit SensorGroup04;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls, ExtCtrls,
  Sensor01;

type
  TSensorGroup04Form = class(TForm)
    Panel1: TPanel;
    Label1: TLabel;
    procedure FormDestroy(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  SensorGroup04Form: TSensorGroup04Form;

// ================================================================
//     
// ================================================================
//      
// (   !)
const Max04SensorIndex = 11;

//  
// ( !)
var   SensorsArr04 : array [0..Max04SensorIndex] of TSensor;

// ================================================================
// ================================================================

implementation
{$R *.dfm}

// ================================================================
// ================================================================

// ================================================================
//      
// ================================================================
// ----------------------------------------------------------------
//        
type TSensorsDesc = record
  XB    : integer;     // Left -     
  YB    : integer;     // Top  -     
  Title : string;      //   
  Min   : integer;     //    
  Max   : integer;     //    
end;
// ----------------------------------------------------------------
//   
const SensorsDesc : array [0..Max04SensorIndex] of TSensorsDesc =
( //  
  ( XB : 10;  YB : 40;        Title : '  1'; Min : -50;  Max : 100),
  ( XB : 10;  YB : 40 + 140;  Title : '  1'; Min : 0;  Max : 10),
  ( XB : 10;  YB : 40 + 280;  Title : '  2'; Min : 0;  Max : 10),
  ( XB : 10;  YB : 40 + 420;  Title : '  2'; Min : -50;  Max : 100),
  //  
  ( XB : 260; YB : 40;        Title : '  3';  Min : 0;  Max : 10),
  ( XB : 260; YB : 40 + 140;  Title : '  4';  Min : 0;  Max : 10),
  ( XB : 260; YB : 40 + 280;  Title : '  1';   Min : 0;  Max : 500),
  ( XB : 260; YB : 40 + 420;  Title : '  2';   Min : 0;  Max : 1000),
  //  
  ( XB : 510; YB : 40;        Title : '  5';  Min : -50;  Max : 100),
  ( XB : 510; YB : 40 + 140;  Title : '  6';  Min : -50;  Max : 100),
  ( XB : 510; YB : 40 + 280;  Title : '   1';   Min : 00;  Max : 10),
  ( XB : 510; YB : 40 + 420;  Title : '   2';   Min : 00;  Max : 100)
);

// ================================================================
//    / 
// ================================================================
// ----------------------------------------------------------------
//     
procedure TSensorGroup04Form.FormCreate(Sender: TObject);
var Ind : integer;
begin
   Panel1.Color := RGB(160,200,200);
   for Ind := Low(SensorsArr04) to High(SensorsArr04)
   do begin
      if not Assigned(SensorsArr04[Ind])
      then begin
         SensorsArr04[Ind] := TSensor.Create(Panel1,
                              SensorsDesc[Ind].XB,
                              SensorsDesc[Ind].YB);
         with SensorsArr04[Ind]
         do begin
           Indx  := Ind;
           Title := SensorsDesc[Ind].Title;
           Min   := SensorsDesc[Ind].Min;
           Max   := SensorsDesc[Ind].Max;
         end;
      end;
   end;
   // Edit1.Text := IntToStr(AllocMemSize);
end;
// ----------------------------------------------------------------
//     
procedure TSensorGroup04Form.FormDestroy(Sender: TObject);
var Ind : integer;
begin
   for Ind := Low(SensorsArr04) to High(SensorsArr04)
   do begin
      if Assigned(SensorsArr04[Ind])
      then begin
       SensorsArr04[Ind].Free;
       SensorsArr04[Ind] := nil;
      end;
   end;
end;
// ================================================================
//   
// ================================================================
end.
